<?php

// ---------------------------------------------
//  © S.G.Schiffer 2025 - sgs-visual.de
//  Lesen Sie bitte den Haftungsausschluss der der Download-Datei beigefügt wurde.
//  Dieses Script ist Urheberrechtlich geschützt und darf nicht zum Download auf 
//  anderen Webseiten angeboten oder kommerziell genutzt werden.
//  ----------------------------------------------


// Pfad zur JSON-Datei
$counter_json = __DIR__ . '/sgs_count/sgs_counter.json';

// Datei prüfen und laden
if (!file_exists($counter_json)) {
        echo "<p>Keine Download-Daten gefunden.</p>";
        return;
}

$counter_data = json_decode(file_get_contents($counter_json), true);
if (!is_array($counter_data) || empty($counter_data)) {
        echo "<p>Keine Download-Daten vorhanden.</p>";
        return;
}

// Gesamtsumme berechnen
$total = array_sum($counter_data);

// Tabelle ausgeben
echo '<table style="border-collapse:collapse; font-family:Arial, sans-serif; font-size:14px;">';
echo '<tr style="background:#000; color:#fff; font-weight:600;">
                <th style="border:1px solid #000; padding:6px 12px;">Dateiname</th>
                <th style="border:1px solid #000; padding:6px 12px;">Downloads</th>
            </tr>';

foreach ($counter_data as $filename => $count) {
        echo '<tr>
                        <td style="border:1px solid #000; padding:6px 12px;">' . htmlspecialchars($filename) . '</td>
                        <td style="border:1px solid #000; padding:6px 12px; text-align:right;">' . (int)$count . '</td>
                    </tr>';
}

echo '<tr style="background:#000; font-weight:600; color: #FFF;">
                <td style="border:1px solid #000; padding:6px 12px;">Downloads Gesamt:</td>
                <td style="border:1px solid #000; padding:6px 12px; text-align:right;">' . $total . '</td>
            </tr>';
echo '</table>';
?>